function [a, u, p, d]  = getValues(ssm, t, x)
%GETVALUES get values for the fields of ssm at time t, depending on the
%states x

    % Get names of states from obj
    [stateNames, auxNames, ctrlNames, ...
    paramNames, inputNames] = getFieldNames(ssm);

    % get parameters p
    for n=1:length(paramNames)
        p.(paramNames{n}) = ssm.p.(paramNames{n}).val;
    end

    % get inputs d
    for k=1:length(inputNames)
        if t < ssm.d.(inputNames{k}).val(1,1)
            d.(inputNames{k}) = ssm.d.(inputNames{k}).val(1,2);
        elseif t > ssm.d.(inputNames{k}).val(end,1)
            d.(inputNames{k}) = ssm.d.(inputNames{k}).val(end,2);
        else
            d.(inputNames{k}) = interp1(ssm.d.(inputNames{k}).val(:,1),...
                ssm.d.(inputNames{k}).val(:,2),t); 
        end                
    end
        
    % get controls u 
    for k=1:length(ctrlNames)
        if isscalar(ssm.u.(ctrlNames{k}).val)
            % the val for u is scalar, just take that
            u.(ctrlNames{k}) = ssm.u.(ctrlNames{k}).val;
        elseif strcmp(ssm.u.(ctrlNames{k}).def, ['u.' ctrlNames{k}]) 
            % the def for the control is the control name, control acts as input
             if t < ssm.u.(ctrlNames{k}).val(1,1)
                u.(ctrlNames{k}) = ssm.u.(ctrlNames{k}).val(1,2);
            elseif t > ssm.u.(ctrlNames{k}).val(end,1)
                u.(ctrlNames{k}) = ssm.u.(ctrlNames{k}).val(end,2);
            else
                u.(ctrlNames{k}) = interp1(ssm.u.(ctrlNames{k}).val(:,1),...
                    ssm.u.(ctrlNames{k}).val(:,2),t); 
             end
        else % control is rule based, acts as an auxiliary state
            % need to calculate
            try
                u.(ctrlNames{k}) = eval(ssm.u.(ctrlNames{k}).def);
            catch err
                msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
                    err.message, ctrlNames{k}, k, ssm.u.(ctrlNames{k}).def);
                id = 'MATLAB:StateSpaceModel:eval';
                error(id,msg);
            end
        end
    end

    % get auxiliary states a
    for n=1:length(auxNames)
        try
            a.(auxNames{n}) = eval(ssm.a.(auxNames{n}).def);
        catch err
            msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
                err.message, auxNames{n}, n, ssm.a.(auxNames{n}).def);
            id = 'MATLAB:StateSpaceModel:eval';
            error(id,msg);
        end
    end
    
end


% 
% 
% function dxdt = getOde(t, x, ssm)
% % GETODE Get the ODEs of a StateSpaceModel in a format for MATLAB's ODE solvers
% 
%     [stateNames, auxNames, ctrlNames, paramNames, inputNames] = getFieldNames(obj);
%         
%     % get inputs d
%     for k=1:length(inputNames)
%         if t < obj.d.(inputNames{k}).val(1,1)
%             d.(inputNames{k}) = obj.d.(inputNames{k}).val(1,2);
%         elseif t > obj.d.(inputNames{k}).val(end,1)
%             d.(inputNames{k}) = obj.d.(inputNames{k}).val(end,2);
%         else
%             d.(inputNames{k}) = interp1(obj.d.(inputNames{k}).val(:,1),...
%                 obj.d.(inputNames{k}).val(:,2),t); 
%         end                
%     end
%         
%     % get controls u 
%     for k=1:length(ctrlNames)
%         if strcmp(obj.u.(ctrlNames{k}).def, ['u.' ctrlNames{k}]) 
%             % the def for the control is the control name, control acts as input
%              if t < obj.u.(ctrlNames{k}).val(1,1)
%                 u.(ctrlNames{k}) = obj.u.(ctrlNames{k}).val(1,2);
%             elseif t > obj.u.(ctrlNames{k}).val(end,1)
%                 u.(ctrlNames{k}) = obj.u.(ctrlNames{k}).val(end,2);
%             else
%                 u.(ctrlNames{k}) = interp1(obj.u.(ctrlNames{k}).val(:,1),...
%                     obj.u.(ctrlNames{k}).val(:,2),tHalf); 
%              end
%         else % control is rule based, acts as an auxiliary state
%             % need to calculate
%             try
%                 u.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
%             catch err
%                 msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                     err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                 id = 'MATLAB:StateSpaceModel:eval';
%                 error(id,msg);
%             end
%         end
%     end
%     
%     
%         % get uHalf = u(xHalf, a0)
%     x = xHalf;
%     d = dHalf;
%     a = a0;
%     u = u0;
%     if nextCtrl
%         for k=1:length(ctrlNames)
%             if isempty(u.(ctrlNames{k})) % need to calculate
%                 
%             end
%         end
%     else
%         u = u0;
%     end
%     
% end


%     
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
%         
% 
%     % Calculate k2 = stepSize*f(tHalf,x0+k1/2)
%     k2  = getK(obj, stepSize, xHalf, aHalf, uHalf, dHalf, p);
% 
%     % calculate xHalf = x+k2/2
%     for k=1:length(stateNames)
%         xHalf.(stateNames{k}) = x0.(stateNames{k})+1/2*k2.(stateNames{k});            
%     end
%     
%     % get uHalf = u(xHalf)
%     x = xHalf;
%     d = dHalf;
%     if nextCtrl
%         for k=1:length(ctrlNames)
%             if isempty(uHalf.(ctrlNames{k})) % need to calculate
%                 try
%                     uHalf.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         uHalf = u0;
%     end
% 
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
%     
%     % Calculate k3 = stepSize*f(tHalf,x0+k2/2)
%     k3  = getK(obj, stepSize, xHalf, aHalf, uHalf, dHalf, p);
% 
%     % calculate xHalf = x+k3
%     for k=1:length(stateNames)
%         xHalf.(stateNames{k}) = x0.(stateNames{k})+k3.(stateNames{k});            
%     end
%     
%     % get uHalf = u(xHalf)
%     x = xHalf;
%     d = dHalf;
%     if nextCtrl
%         for k=1:length(ctrlNames)
%             if isempty(uHalf.(ctrlNames{k})) % need to calculate
%                 try
%                     uHalf.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         uHalf = u0;
%     end
%     
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
% 
%     % Calculate k4 = stepSize*f(t1,x0+k3)
%     k4  = getK(obj, stepSize, xHalf, aHalf, uHalf, d1, p);
% 
%     % calculate x1 = x0+1/6(k1+2*k2+2*k3+k4)
%     for k=1:length(stateNames)
%         x1.(stateNames{k}) = x0.(stateNames{k})+...
%             1/6*(k1.(stateNames{k})+2*k2.(stateNames{k})+2*k3.(stateNames{k})...
%             +k4.(stateNames{k}));            
%     end
%     
%     % get u1 = u(x1)
%     x = x1;
%     d = d1;
%     if nextCtrl
%         u = uHalf;
%         for k=1:length(ctrlNames)
%             if isempty(u1.(ctrlNames{k})) % need to calculate
%                 try
%                     u1.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def); 
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         u1 = u0;
%     end
%     
%     % get a1 = a(x1, u1)
%     u = u1;
%     for n=1:length(auxNames)
%         try
%             a1.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
% end
% 
% function k = getK(obj, stepSize, x, a, u, d, p)
%     % k = stepSize*f(t,x)
%     
%     [stateNames, ~, ~, ~, ~] = getFieldNames(obj);
%     
%     for n=1:length(stateNames)
%         try
%             k.(stateNames{n}) = stepSize*eval(obj.x.(stateNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement x.%s (k=%d): \n\t''%s''',...
%                 err.message, stateNames{n}, n, obj.x.(stateNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%         if ~isreal(k.(stateNames{n}))
%             warning('x.%s is complex',stateNames{n});
%         elseif isnan(k.(stateNames{n}))
%             warning('x.%s is NaN',stateNames{n});
%         end
%     end
% end
% 
% 
% end